//	MarqueeUtils.h

#include <M.h>

#ifndef _H_MarqueeUtils
#define _H_MarqueeUtils

typedef	struct {
	//	edges
	unsigned	short	left				: 1;
	unsigned	short	top					: 1;
	unsigned	short	right				: 1;
	unsigned	short	bottom				: 1;
	
	unsigned	short	hit_edge			: 1;	//	true iff top+left+bottom+right = 1
	unsigned	short	hit_center			: 1;	//	true iff all edges are 0

	unsigned	short	new_marquee			: 1;
	
	unsigned	short	erase_when_done		: 1;
	
	unsigned	short	extra2				: 8;
	unsigned	short	extra1				: 16;
} MU_HitRec;

extern	MU_HitRec	MU_NEW_MARQUEE;			//	erase when done FALSE
extern	MU_HitRec	MU_NEW_MARQUEE_ERASE;	//	erase when done TRUE

#define		MU_CLEAR_HIT_REC(HR)	U_MEMCLR(sizeof(MU_HitRec), &(HR))

typedef		Boolean	(*MU_WillAutoScrollCB)(M_FixedPoint thePoint, M_Rect *frameRect, void *data);
typedef		Boolean	(*MU_DoAutoScrollCB)(M_FixedPoint thePoint, M_Rect *frameRect, M_FixedPoint *offset, void *data);
typedef		Boolean	(*MU_StateChangedCB)(M_FixedRect *fixRect, void *data);
typedef		void	(*MU_SnapRectToViewAreaCB)(M_FixedRect *localRect, M_FixedPoint *deltaPoint, void *data);
typedef		void	(*MU_UpdateScreenInfoCB)(M_FixedRect *origFixRect, M_FixedRect *newFixRect, void *data);
typedef		void	(*MU_DrawMarqueeShapeCB)(Boolean oval, M_FixedRect *newFixRect, void *data);

typedef	struct {
	MU_WillAutoScrollCB			WillAutoScroll;
	MU_DoAutoScrollCB			DoAutoScroll;
	MU_SnapRectToViewAreaCB		SnapRectToViewArea;
	MU_UpdateScreenInfoCB		UpdateScreenInfo;
	MU_DrawMarqueeShapeCB		DrawMarqueeShape;
	MU_StateChangedCB			StateChanged;
	M_Rect						frameRect;	//	used for autoscroll, the frame can change
	void						*data0;
} MU_CallbacksRec;

#define		MU_CLEAR_CALLBACKS_REC(CB)		U_MEMCLR(sizeof(MU_CallbacksRec), &(CB))

void		MU_StretchRect(
	MU_HitRec		hitRec, 
	Boolean			size_from_center, 
	M_FixedPoint	origFixPoint, 
	M_FixedPoint	deltaFixPoint, 
	Boolean			can_constrain, 
	M_Ratio			*aspect_ratio0, 
	MU_CallbacksRec	*callbacks0, 
	M_FixedRect		*fixRect);


Err			MU_Marquee(
	MU_HitRec			hitRec, 
	Boolean				size_from_center, 
	M_FixedPoint		origFixPoint, 
	Boolean				can_constrain, 
	M_Ratio				*aspect_ratio0, 	//	iff can_constrain
	Boolean				oval, 
	MU_CallbacksRec		*callbacks0, 
	M_FixedRect			*destFixRect);

void		MU_LimitFixRect(M_FixedRect *limitFixBounds, M_FixedRect *theFixRect);
void		MU_LimitRect(Rect *limitBounds, Rect *theRect);

#define FRAME_FIXED_RECT_OR_OVAL(oval, fixRect)	\
	do {										\
		Rect	shortRect;						\
												\
		FIX2SHORTRECT(fixRect, shortRect);		\
												\
		if (oval)								\
			FrameOval(&shortRect);				\
		else 									\
			FrameRect(&shortRect);				\
												\
	} while (0)

/*
callbacks
	autoscroll
	keys
	modifiers
	snapping
	realtime updating
	updating selection
*/

#endif